@extends('layouts.admin')

@section('title', 'Create Content')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Create Content</h1>
    <a href="{{ route('admin.contents.index') }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back to List
    </a>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.contents.store') }}" method="POST">
            @csrf
            
            <div class="mb-3">
                <label for="page_key" class="form-label">Page Key <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('page_key') is-invalid @enderror" id="page_key" name="page_key" value="{{ old('page_key') }}" placeholder="e.g., home_hero_title" required>
                <small class="form-text text-muted">Unique identifier for this content (e.g., home_hero_title, about_intro)</small>
                @error('page_key')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="section" class="form-label">Section</label>
                <input type="text" class="form-control @error('section') is-invalid @enderror" id="section" name="section" value="{{ old('section') }}" placeholder="e.g., home, about, contact">
                <small class="form-text text-muted">Group content by section (optional)</small>
                @error('section')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="label" class="form-label">Label <span class="text-danger">*</span></label>
                <input type="text" class="form-control @error('label') is-invalid @enderror" id="label" name="label" value="{{ old('label') }}" placeholder="e.g., Home Hero Title" required>
                <small class="form-text text-muted">Human-readable label for this content</small>
                @error('label')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="type" class="form-label">Content Type <span class="text-danger">*</span></label>
                <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                    <option value="text" {{ old('type') == 'text' ? 'selected' : '' }}>Text</option>
                    <option value="html" {{ old('type') == 'html' ? 'selected' : '' }}>HTML</option>
                    <option value="image" {{ old('type') == 'image' ? 'selected' : '' }}>Image URL</option>
                </select>
                @error('type')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="content" class="form-label">Content</label>
                <textarea class="form-control @error('content') is-invalid @enderror" id="content" name="content" rows="8">{{ old('content') }}</textarea>
                @error('content')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle"></i> Create Content
                </button>
                <a href="{{ route('admin.contents.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection



